<?php
// inc/telegram.php - Telegram API Functions

/**
 * Send Telegram API request
 */
function bot($method, $data = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($result, true);
}

/**
 * Send message to user
 */
function send_message($chat_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    
    return bot('sendMessage', $data);
}

/**
 * Send document to user
 */
function send_document($chat_id, $document_path, $caption = '') {
    $data = [
        'chat_id' => $chat_id,
        'caption' => $caption
    ];
    
    $document = new CURLFile(realpath($document_path));
    $data['document'] = $document;
    
    return bot('sendDocument', $data);
}

/**
 * Check if user is member of a channel
 */
function is_telegram_member($user_id, $channel) {
    // Remove @ if present
    $channel = ltrim($channel, '@');
    
    try {
        $response = bot('getChatMember', [
            'chat_id' => '@' . $channel,
            'user_id' => $user_id
        ]);
        
        if ($response['ok']) {
            $status = $response['result']['status'];
            return in_array($status, ['member', 'administrator', 'creator']);
        }
    } catch (Exception $e) {
        error_log("Error checking membership: " . $e->getMessage());
    }
    
    return false;
}

/**
 * Create inline keyboard
 */
function create_inline_keyboard($buttons) {
    return ['inline_keyboard' => $buttons];
}

/**
 * Create join channels keyboard
 */
function create_join_keyboard($channels) {
    $buttons = [];
    
    foreach ($channels as $channel) {
        $channel = trim($channel);
        $buttons[] = [
            [
                'text' => "Join " . $channel,
                'url' => "https://t.me/" . ltrim($channel, '@')
            ]
        ];
    }
    
    $buttons[] = [
        [
            'text' => "✅ I've Joined",
            'callback_data' => 'check_membership'
        ]
    ];
    
    return create_inline_keyboard($buttons);
}

/**
 * Answer callback query
 */
function answer_callback_query($callback_id, $text, $show_alert = false) {
    return bot('answerCallbackQuery', [
        'callback_query_id' => $callback_id,
        'text' => $text,
        'show_alert' => $show_alert
    ]);
}

/**
 * Edit message text
 */
function edit_message_text($chat_id, $message_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    
    return bot('editMessageText', $data);
}
?>