<?php
// config.php - Main Configuration File for Telegram File Locker Bot

// =============================================
// 🤖 BOT CONFIGURATION
// =============================================

// Bot Token from @BotFather
define('BOT_TOKEN', '8435386031:AAFycTc_DCOEt2cZ-NgYXSYlySdaRs_9-ys');

// Bot Username (without @)
define('BOT_USERNAME', 'Privatefibot');

// Your Telegram User ID (Get from @userinfobot)
define('ADMIN_ID', '5965337339');

// Admin Contact Information
define('ADMIN_USERNAME', 'rk_tread'); // Without @
define('ADMIN_CONTACT_URL', 'https://t.me/rk_tread');

// =============================================
// 🗄️ DATABASE CONFIGURATION
// =============================================

// Database Host (usually localhost)
define('DB_HOST', 'localhost');

// Database Name
define('DB_NAME', 'gevzvkky_haku');

// Database Username
define('DB_USER', 'gevzvkky_haku');

// Database Password
define('DB_PASS', 'gevzvkky_haku');

// =============================================
// 🌐 WEBSITE CONFIGURATION
// =============================================

// Your Website Base URL (with trailing slash)
define('BASE_URL', 'https://squids.in/bot/webhook.php');

// Webhook URL (Don't change this)
define('WEBHOOK_URL', BASE_URL . 'webhook.php');

// Admin Panel URL
define('ADMIN_URL', BASE_URL . 'admin.php');

// =============================================
// 🔐 SECURITY CONFIGURATION
// =============================================

// Admin Panel Security Token (Choose a strong random token)
define('ADMIN_TOKEN', 'Rocky095');

// Optional: IP Whitelist for Admin Panel (empty = allow all)
define('ALLOWED_IPS', []); // Example: ['123.456.789.0', '192.168.1.1']

// =============================================
// 📁 FILE UPLOAD SETTINGS
// =============================================

// Maximum File Size (in bytes)
define('MAX_FILE_SIZE', 50 * 1024 * 1024); // 50MB

// Allowed File Types
define('ALLOWED_TYPES', [
    'pdf', 'zip', 'rar', 
    'doc', 'docx', 'xls', 'xlsx', 
    'jpg', 'jpeg', 'png', 'gif',
    'mp4', 'mp3', 'wav', 'avi',
    'txt', 'ppt', 'pptx'
]);

// Upload Directory
define('UPLOAD_DIR', __DIR__ . '/uploads/');

// =============================================
// ⚙️ SYSTEM SETTINGS
// =============================================

// Timezone
date_default_timezone_set('Asia/Kolkata');

// Error Reporting (Set to 0 in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Bot Mode (development/production)
define('BOT_MODE', 'development'); // Change to 'production' when live

// =============================================
// 💰 PAYMENT SETTINGS (For Reference)
// =============================================

// Payment Methods (for admin reference)
define('PAYMENT_METHODS', [
    'UPI' => 'motaman@axl',
    'PayPal' => 'not accpet',
    'Bank Transfer' => 'not accpet'
]);

// Default Currency
define('DEFAULT_CURRENCY', '₹');

// =============================================
// 📊 LOGGING SETTINGS
// =============================================

// Enable Logging
define('ENABLE_LOGGING', true);

// Log File Path
define('LOG_FILE', __DIR__ . '/logs/bot_log.txt');

// =============================================
// 🔄 CUSTOM MESSAGES
// =============================================

// Welcome Message Customization
define('WELCOME_TITLE', '👋 Welcome to File Locker Bot!');
define('WELCOME_SUBTITLE', '📦 Your Ultimate File Sharing Solution');

// Bot Description
define('BOT_DESCRIPTION', 
    "This bot provides secure file sharing with channel verification. " .
    "Access free and premium content by joining required channels."
);

// =============================================
// 🛡️ SECURITY CHECKS
// =============================================

// Check if config is accessed directly
if (basename($_SERVER['PHP_SELF']) == 'config.php') {
    die('Access denied!');
}

// =============================================
// 📝 AUTO-CONFIGURATION CHECKS
// =============================================

// Create uploads directory if not exists
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}

// Create logs directory if not exists
if (!file_exists(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0755, true);
}

// Check if important constants are set
function check_config() {
    $required_constants = [
        'BOT_TOKEN', 'ADMIN_ID', 'DB_HOST', 
        'DB_NAME', 'DB_USER', 'DB_PASS'
    ];
    
    foreach ($required_constants as $constant) {
        if (!defined($constant) || constant($constant) == 'YOUR_' . $constant) {
            error_log("Configuration Error: $constant is not properly set.");
            return false;
        }
    }
    return true;
}

// Run configuration check
check_config();

// =============================================
// 🎯 VERSION INFORMATION
// =============================================

define('BOT_VERSION', '2.0');
define('LAST_UPDATED', '2024-01-01');

?>